<?php

namespace App\Http\Controllers;

use App\Models\UploadedEvaluation;
use App\Http\Requests\StoreUploadedEvaluationRequest;
use App\Http\Requests\UpdateUploadedEvaluationRequest;

class UploadedEvaluationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreUploadedEvaluationRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUploadedEvaluationRequest $request)
    {
        try {
            // check if student is upload evaluation before
            // $is_uploaded = UploadedEvaluation::where('subscribe_id', $request->subscriberId)->first();
            // if (isset($is_uploaded))
            //     return redirect()->route('user_dash')->with(['info' => 'لقد قمت بتعبئة هذا الاستبيان من قبل']);

            // check if radios is not empty
            if (isset($request->benefit) || !$request->benefit == null || !$request->benefit == [])
                foreach ($request->benefit as $key => $benefit) {
                    // save options values
                    $studentEvaluation = new UploadedEvaluation();
                    $studentEvaluation->evaluation_value_id = $key;
                    $studentEvaluation->subscribe_id = $request->subscriberId;
                    $studentEvaluation->value = $benefit;
                    $studentEvaluation->save();
                }
            // check if text textarea is not empty
            if (isset($request->txtValue) || !$request->txtValue == null || !$request->txtValue == [])
                foreach ($request->txtValue as $key => $txtValue) {
                    // check if text textarea is not empty
                    if (!isset($request->txtValue[$key]) || $request->txtValue[$key] == null || $request->txtValue[$key] == [])
                        continue;

                    // save text values
                    $studentEvaluation = new UploadedEvaluation();
                    $studentEvaluation->evaluation_value_id = $key;
                    $studentEvaluation->subscribe_id = $request->subscriberId;
                    $studentEvaluation->value = $txtValue;
                    $studentEvaluation->save();
                }

            return redirect()->route('user_dash')->with(['success' => 'شكراً على تعبت الاستبيان فرأيك يساعدنا كثيرا في تطوير منصتنا']);
        } catch (\Throwable $th) {
            return back()->with(['success' => 'عذراً هناك خطأ لم يتم رع الاستبيان']);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UploadedEvaluation  $uploadedEvaluation
     * @return \Illuminate\Http\Response
     */
    public function show(UploadedEvaluation $uploadedEvaluation)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\UploadedEvaluation  $uploadedEvaluation
     * @return \Illuminate\Http\Response
     */
    public function edit(UploadedEvaluation $uploadedEvaluation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateUploadedEvaluationRequest  $request
     * @param  \App\Models\UploadedEvaluation  $uploadedEvaluation
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateUploadedEvaluationRequest $request, UploadedEvaluation $uploadedEvaluation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UploadedEvaluation  $uploadedEvaluation
     * @return \Illuminate\Http\Response
     */
    public function destroy(UploadedEvaluation $uploadedEvaluation)
    {
        //
    }
}
